class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Film Critic Reviews'
    oldest_article = 30
    max_articles_per_feed = 200
    use_embedded_content  = False
    no_stylesheets = True
    encoding              = 'utf8'

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    keep_only_tags = [dict(name='div',attrs={'id':'alpha'})]
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['asset-meta','asset-rating','iva-photo-gallery','asset-authorbio','social-counters','asset-footer']}),
                   dict(name='div', attrs={'id':['','',]}),
                   dict(name='ul', attrs={'class':['']}),
                   dict(name='ul', attrs={'id':['']}),
                   dict(name='ol', attrs={'id':['']}),
                   dict(name='span', attrs={'class':['']}),
                   dict(name='p', attrs={'id':''}),
                   dict(name=['img','iframe']),]

    feeds          = (u'Reviews', u'http://www.filmcritic.com/atom.xml')
                            
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		
    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'GALLERY' in article.title.upper():
            feed.articles.remove(article)
          elif 'VIDEO' in article.url.upper():
            feed.articles.remove(article)
      return feeds